//
//  EmployeeTypeTableViewController.swift
//  EmployeeRoster
//

import UIKit

protocol EmployeeTypeDelegate: class {
    func didSelect(employeeType: EmployeeType)
}

class EmployeeTypeTableViewController: UITableViewController {

    struct PropertyKeys {
        static let employeeTypeCell = "EmployeeTypeCell"
    }
    
    var employeeType: EmployeeType?
    
    weak var delegate: EmployeeTypeDelegate?

    // MARK: - Table view data source

    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return EmployeeType.all.count
    }

    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: PropertyKeys.employeeTypeCell, for: indexPath)

        let type = EmployeeType.all[indexPath.row]
        cell.textLabel?.text = type.description()
        
        if employeeType == type {
            cell.accessoryType = .checkmark
        } else {
            cell.accessoryType = .none
        }
        
        return cell
    }

    // MARK: Table View Delegate
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let employeeType = EmployeeType.all[indexPath.row]
        self.employeeType = employeeType
        delegate?.didSelect(employeeType: employeeType)
        tableView.reloadData()
    }
}
